<?php
/*
Plugin Name: Tutsplus simplepie recent post
Plugin URI: http://code.tutsplus.com/building-a-recent-post-widget-powered-by-simplepie
Description: Recent post widget plugin powered by SimplePie.
Author: Agonghama Collins
Author URI: http://tech4sky.com
*/


class Foo_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'foo_testid', // Base ID
			__('Recent Post powered by SimplePie', 'text_domain'), // Name
			array( 'description' => __( 'Most recent posts generated from website feed', 'text_domain' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$feedURL = empty( $instance['feedURL'] ) ? site_url().'/feed' : $instance['feedURL'];
        $feedNumber = (int) empty( $instance['feedNumber'] ) ? 5 : $instance['feedNumber']; 
		$showDate = empty( $instance['showDate'] ) ? 0 : 1;
        $showDescription = empty( $instance['showDescription'] ) ? 0 : 1; 
		
		
		echo $args['before_widget'];
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . $args['after_title'];
		
include_once( ABSPATH . WPINC . '/feed.php' );

// Get a SimplePie feed object from the specified feed source.
$rss = fetch_feed( $feedURL );

if ( ! is_wp_error( $rss ) ) : // Checks that the object is created correctly

    // Figure out how many total items there are, but limit it to 5. 
    $maxitems = $rss->get_item_quantity( $feedNumber ); 

    // Build an array of all the items, starting with element 0 (first element).
    $rss_items = $rss->get_items( 0, $maxitems );

endif;
?>

<ul>
	<?php if ( $maxitems == 0 ) :
	?>
	<li><?php echo "No item found"; ?></li>
	<?php else : ?>
	<?php // Loop through each feed item and display each item as a hyperlink. ?>
	<?php foreach ( $rss_items as $item ) :
	?>
	<li>
		<a href="<?php echo esc_url($item -> get_permalink()); ?>"
		title="<?php echo esc_html($item -> get_title()); ?>"> <?php echo esc_html($item -> get_title()); ?> </a>
		<?php
			if ($showDate) { echo "<span class='date'>" . $item -> get_date('F j Y') . "</span>";
			}
		?>
		<?php
		if ($showDescription) { echo "<div class='description'>" . $item -> get_description() . "</div>";
		}
		?>
	</li>
	<?php endforeach; ?>
	<?php endif; ?>
</ul>

<?php echo $args['after_widget'];
	}

	/**
	* Back-end widget form.
	*
	* @see WP_Widget::form()
	*
	* @param array $instance Previously saved values from database.
	*/

	//build the widget settings form
	public function form( $instance ) {

	$defaults = array('title' => 'Recent Posts',
	'feedURL' => get_site_url() .'/feed',
	'feedNumber' => 5
	);
	$instance = wp_parse_args( (array) $instance, $defaults );
	$title = $instance['title'];
	$feedURL = $instance['feedURL'];
	$feedNumber = $instance['feedNumber'];
	$showDate = $instance['showDate'];
	$showDescription = $instance['showDescription'];
?>
<p>
	<label for="<?php echo $this -> get_field_id('title'); ?>">Title:</label>
	<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
</p>
<label for="<?php echo $this -> get_field_id('feedURL'); ?>">Feed:</label>
<input class="widefat" id="<?php echo $this -> get_field_id('feedURL'); ?>" name="<?php echo $this -> get_field_name('feedURL'); ?>" type="text" value="<?php echo esc_attr($feedURL); ?>">
</p>
<label for="<?php echo $this -> get_field_id('feedNumber'); ?>">Number of posts to show:</label>
<input id="<?php echo $this -> get_field_id('feedNumber'); ?>" name="<?php echo $this -> get_field_name('feedNumber'); ?>" size="3" type="text" value="<?php echo esc_attr($feedNumber); ?>">
</p>
<label for="<?php echo $this -> get_field_id('showDate'); ?>">Show Date?:</label>
<input name="<?php echo $this -> get_field_name('showDate'); ?>" value="1" type="checkbox" <?php checked($showDate, 1); ?>">
</p>
<label for="<?php echo $this -> get_field_id('showDescription'); ?>
">Show Summary?:</label>
<input name="<?php echo $this -> get_field_name('showDescription'); ?>" value="1" type="checkbox" <?php checked($showDescription, 1); ?>">
</p>
<?php
}

/**
* Sanitize widget form values as they are saved.
*
* @see WP_Widget::update()
*
* @param array $new_instance Values just sent to be saved.
* @param array $old_instance Previously saved values from database.
*
* @return array Updated safe values to be saved.
*/
public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
$instance['feedURL'] = ( ! empty( $new_instance['feedURL'] ) ) ? strip_tags( $new_instance['feedURL'] ) : '';
$instance['feedNumber'] = ( ! empty( $new_instance['feedNumber'] ) ) ? strip_tags( $new_instance['feedNumber'] ) : '';
$instance['showDate'] = ( ! empty( $new_instance['showDate'] ) ) ? strip_tags( $new_instance['showDate'] ) : '';
$instance['showDescription'] = ( ! empty( $new_instance['showDescription'] ) ) ? strip_tags( $new_instance['showDescription'] ) : '';

return $instance;
}

}

// register Foo_Widget widget
function register_foo_widget() {
register_widget( 'Foo_Widget' );
}
add_action( 'widgets_init', 'register_foo_widget' );
